<?php
/**
 * SendSmsApi
 * PHP version 7.2
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */

/**
 * Infobip Client API Libraries OpenAPI Specification
 *
 * OpenAPI specification containing public endpoints supported in client API libraries.
 *
 * Contact: support@infobip.com
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * Do not edit the class manually.
 */

namespace Infobip\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Utils;
use GuzzleHttp\RequestOptions;
use Infobip\ApiException;
use Infobip\Configuration;
use Infobip\HeaderSelector;
use Infobip\ObjectSerializer;

/**
 * SendSmsApi Class Doc Comment
 *
 * @category Class
 * @package  Infobip
 * @author   Infobip Support
 * @link     https://www.infobip.com
 */
class SendSmsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
    * @param ClientInterface $client
    * @param Configuration   $config
    * @param HeaderSelector  $selector
    */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getOutboundSmsMessageDeliveryReports
     *
     * Get outbound SMS message delivery reports
     *
     * @param  string $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string $messageId Unique message ID for which a report is requested. (optional)
     * @param  int $limit Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access reports for the last 48h. (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsDeliveryResult
     */
    public function getOutboundSmsMessageDeliveryReports($bulkId = null, $messageId = null, $limit = null)
    {
        list($response) = $this->getOutboundSmsMessageDeliveryReportsWithHttpInfo($bulkId, $messageId, $limit);
        return $response;
    }

    /**
     * Operation getOutboundSmsMessageDeliveryReportsWithHttpInfo
     *
     * Get outbound SMS message delivery reports
     *
     * @param  string $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string $messageId Unique message ID for which a report is requested. (optional)
     * @param  int $limit Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access reports for the last 48h. (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsDeliveryResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOutboundSmsMessageDeliveryReportsWithHttpInfo($bulkId = null, $messageId = null, $limit = null)
    {
        $request = $this->getOutboundSmsMessageDeliveryReportsRequest($bulkId, $messageId, $limit);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getOutboundSmsMessageDeliveryReportsResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getOutboundSmsMessageDeliveryReportsApiException($e);
        }
    }

    /**
     * Operation getOutboundSmsMessageDeliveryReportsAsync
     *
     * Get outbound SMS message delivery reports
     *
     * @param  string $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string $messageId Unique message ID for which a report is requested. (optional)
     * @param  int $limit Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access reports for the last 48h. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutboundSmsMessageDeliveryReportsAsync($bulkId = null, $messageId = null, $limit = null)
    {
        return $this->getOutboundSmsMessageDeliveryReportsAsyncWithHttpInfo($bulkId, $messageId, $limit)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOutboundSmsMessageDeliveryReportsAsyncWithHttpInfo
     *
     * Get outbound SMS message delivery reports
     *
     * @param  string $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string $messageId Unique message ID for which a report is requested. (optional)
     * @param  int $limit Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access reports for the last 48h. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutboundSmsMessageDeliveryReportsAsyncWithHttpInfo($bulkId = null, $messageId = null, $limit = null)
    {
        $request = $this->getOutboundSmsMessageDeliveryReportsRequest($bulkId, $messageId, $limit);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getOutboundSmsMessageDeliveryReportsResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getOutboundSmsMessageDeliveryReportsApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getOutboundSmsMessageDeliveryReports'
     *
     * @param  string $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string $messageId Unique message ID for which a report is requested. (optional)
     * @param  int $limit Maximum number of delivery reports to be returned. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access reports for the last 48h. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getOutboundSmsMessageDeliveryReportsRequest($bulkId = null, $messageId = null, $limit = null)
    {
        $resourcePath = '/sms/1/reports';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }
        // query params
        if ($messageId !== null) {
            $queryParams['messageId'] = $messageId;
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $limit;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getOutboundSmsMessageDeliveryReports'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsDeliveryResult|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getOutboundSmsMessageDeliveryReportsResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsDeliveryResult';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getOutboundSmsMessageDeliveryReports'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getOutboundSmsMessageDeliveryReportsApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsDeliveryResult',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation getOutboundSmsMessageLogs
     *
     * Get outbound SMS message logs
     *
     * @param  string $from The sender ID which can be alphanumeric or numeric. (optional)
     * @param  string $to Message destination address. (optional)
     * @param  string[] $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string[] $messageId Unique message ID for which a log is requested. (optional)
     * @param  string $generalStatus Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: &#x60;ACCEPTED&#x60;, &#x60;PENDING&#x60;, &#x60;UNDELIVERABLE&#x60;, &#x60;DELIVERED&#x60;, &#x60;REJECTED&#x60;, &#x60;EXPIRED&#x60;. (optional)
     * @param  \DateTime $sentSince The logs will only include messages sent after this date. Use it together with &#x60;sentUntil&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  \DateTime $sentUntil The logs will only include messages sent before this date. Use it together with &#x60;sentBefore&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  int $limit Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use &#x60;sentBefore&#x60; and &#x60;sentUntil&#x60; to retrieve them in pages. (optional)
     * @param  string $mcc Mobile Country Code. (optional)
     * @param  string $mnc Mobile Network Code. (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsLogsResponse
     */
    public function getOutboundSmsMessageLogs($from = null, $to = null, $bulkId = null, $messageId = null, $generalStatus = null, $sentSince = null, $sentUntil = null, $limit = null, $mcc = null, $mnc = null)
    {
        list($response) = $this->getOutboundSmsMessageLogsWithHttpInfo($from, $to, $bulkId, $messageId, $generalStatus, $sentSince, $sentUntil, $limit, $mcc, $mnc);
        return $response;
    }

    /**
     * Operation getOutboundSmsMessageLogsWithHttpInfo
     *
     * Get outbound SMS message logs
     *
     * @param  string $from The sender ID which can be alphanumeric or numeric. (optional)
     * @param  string $to Message destination address. (optional)
     * @param  string[] $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string[] $messageId Unique message ID for which a log is requested. (optional)
     * @param  string $generalStatus Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: &#x60;ACCEPTED&#x60;, &#x60;PENDING&#x60;, &#x60;UNDELIVERABLE&#x60;, &#x60;DELIVERED&#x60;, &#x60;REJECTED&#x60;, &#x60;EXPIRED&#x60;. (optional)
     * @param  \DateTime $sentSince The logs will only include messages sent after this date. Use it together with &#x60;sentUntil&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  \DateTime $sentUntil The logs will only include messages sent before this date. Use it together with &#x60;sentBefore&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  int $limit Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use &#x60;sentBefore&#x60; and &#x60;sentUntil&#x60; to retrieve them in pages. (optional)
     * @param  string $mcc Mobile Country Code. (optional)
     * @param  string $mnc Mobile Network Code. (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsLogsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getOutboundSmsMessageLogsWithHttpInfo($from = null, $to = null, $bulkId = null, $messageId = null, $generalStatus = null, $sentSince = null, $sentUntil = null, $limit = null, $mcc = null, $mnc = null)
    {
        $request = $this->getOutboundSmsMessageLogsRequest($from, $to, $bulkId, $messageId, $generalStatus, $sentSince, $sentUntil, $limit, $mcc, $mnc);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->getOutboundSmsMessageLogsResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->getOutboundSmsMessageLogsApiException($e);
        }
    }

    /**
     * Operation getOutboundSmsMessageLogsAsync
     *
     * Get outbound SMS message logs
     *
     * @param  string $from The sender ID which can be alphanumeric or numeric. (optional)
     * @param  string $to Message destination address. (optional)
     * @param  string[] $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string[] $messageId Unique message ID for which a log is requested. (optional)
     * @param  string $generalStatus Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: &#x60;ACCEPTED&#x60;, &#x60;PENDING&#x60;, &#x60;UNDELIVERABLE&#x60;, &#x60;DELIVERED&#x60;, &#x60;REJECTED&#x60;, &#x60;EXPIRED&#x60;. (optional)
     * @param  \DateTime $sentSince The logs will only include messages sent after this date. Use it together with &#x60;sentUntil&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  \DateTime $sentUntil The logs will only include messages sent before this date. Use it together with &#x60;sentBefore&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  int $limit Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use &#x60;sentBefore&#x60; and &#x60;sentUntil&#x60; to retrieve them in pages. (optional)
     * @param  string $mcc Mobile Country Code. (optional)
     * @param  string $mnc Mobile Network Code. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutboundSmsMessageLogsAsync($from = null, $to = null, $bulkId = null, $messageId = null, $generalStatus = null, $sentSince = null, $sentUntil = null, $limit = null, $mcc = null, $mnc = null)
    {
        return $this->getOutboundSmsMessageLogsAsyncWithHttpInfo($from, $to, $bulkId, $messageId, $generalStatus, $sentSince, $sentUntil, $limit, $mcc, $mnc)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getOutboundSmsMessageLogsAsyncWithHttpInfo
     *
     * Get outbound SMS message logs
     *
     * @param  string $from The sender ID which can be alphanumeric or numeric. (optional)
     * @param  string $to Message destination address. (optional)
     * @param  string[] $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string[] $messageId Unique message ID for which a log is requested. (optional)
     * @param  string $generalStatus Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: &#x60;ACCEPTED&#x60;, &#x60;PENDING&#x60;, &#x60;UNDELIVERABLE&#x60;, &#x60;DELIVERED&#x60;, &#x60;REJECTED&#x60;, &#x60;EXPIRED&#x60;. (optional)
     * @param  \DateTime $sentSince The logs will only include messages sent after this date. Use it together with &#x60;sentUntil&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  \DateTime $sentUntil The logs will only include messages sent before this date. Use it together with &#x60;sentBefore&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  int $limit Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use &#x60;sentBefore&#x60; and &#x60;sentUntil&#x60; to retrieve them in pages. (optional)
     * @param  string $mcc Mobile Country Code. (optional)
     * @param  string $mnc Mobile Network Code. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getOutboundSmsMessageLogsAsyncWithHttpInfo($from = null, $to = null, $bulkId = null, $messageId = null, $generalStatus = null, $sentSince = null, $sentUntil = null, $limit = null, $mcc = null, $mnc = null)
    {
        $request = $this->getOutboundSmsMessageLogsRequest($from, $to, $bulkId, $messageId, $generalStatus, $sentSince, $sentUntil, $limit, $mcc, $mnc);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->getOutboundSmsMessageLogsResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->getOutboundSmsMessageLogsApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'getOutboundSmsMessageLogs'
     *
     * @param  string $from The sender ID which can be alphanumeric or numeric. (optional)
     * @param  string $to Message destination address. (optional)
     * @param  string[] $bulkId Unique ID assigned to the request if messaging multiple recipients or sending multiple messages via a single API request. (optional)
     * @param  string[] $messageId Unique message ID for which a log is requested. (optional)
     * @param  string $generalStatus Sent [message status](https://www.infobip.com/docs/essentials/response-status-and-error-codes#api-status-codes). Possible values: &#x60;ACCEPTED&#x60;, &#x60;PENDING&#x60;, &#x60;UNDELIVERABLE&#x60;, &#x60;DELIVERED&#x60;, &#x60;REJECTED&#x60;, &#x60;EXPIRED&#x60;. (optional)
     * @param  \DateTime $sentSince The logs will only include messages sent after this date. Use it together with &#x60;sentUntil&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  \DateTime $sentUntil The logs will only include messages sent before this date. Use it together with &#x60;sentBefore&#x60; to return a time range or if you want to fetch more than 1000 logs allowed per call. Has the following format: &#x60;yyyy-MM-dd&#39;T&#39;HH:mm:ss.SSSZ&#x60;. (optional)
     * @param  int $limit Maximum number of messages to include in logs. If not set, the latest 50 records are returned. Maximum limit value is &#x60;1000&#x60; and you can only access logs for the last 48h. If you want to fetch more than 1000 logs allowed per call, use &#x60;sentBefore&#x60; and &#x60;sentUntil&#x60; to retrieve them in pages. (optional)
     * @param  string $mcc Mobile Country Code. (optional)
     * @param  string $mnc Mobile Network Code. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function getOutboundSmsMessageLogsRequest($from = null, $to = null, $bulkId = null, $messageId = null, $generalStatus = null, $sentSince = null, $sentUntil = null, $limit = null, $mcc = null, $mnc = null)
    {
        $resourcePath = '/sms/1/logs';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';

        // query params
        if ($from !== null) {
            $queryParams['from'] = $from;
        }
        // query params
        if ($to !== null) {
            $queryParams['to'] = $to;
        }
        // query params
        if ($bulkId !== null) {
            $queryParams['bulkId'] = $bulkId;
        }
        // query params
        if ($messageId !== null) {
            $queryParams['messageId'] = $messageId;
        }
        // query params
        if ($generalStatus !== null) {
            $queryParams['generalStatus'] = $generalStatus;
        }
        // query params
        if ($sentSince !== null) {
            $queryParams['sentSince'] = $sentSince;
        }
        // query params
        if ($sentUntil !== null) {
            $queryParams['sentUntil'] = $sentUntil;
        }
        // query params
        if ($limit !== null) {
            $queryParams['limit'] = $limit;
        }
        // query params
        if ($mcc !== null) {
            $queryParams['mcc'] = $mcc;
        }
        // query params
        if ($mnc !== null) {
            $queryParams['mnc'] = $mnc;
        }




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            []
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'getOutboundSmsMessageLogs'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsLogsResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function getOutboundSmsMessageLogsResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsLogsResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'getOutboundSmsMessageLogs'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function getOutboundSmsMessageLogsApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsLogsResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation previewSmsMessage
     *
     * Preview SMS message
     *
     * @param  \Infobip\Model\SmsPreviewRequest $smsPreviewRequest smsPreviewRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsPreviewResponse
     */
    public function previewSmsMessage($smsPreviewRequest = null)
    {
        list($response) = $this->previewSmsMessageWithHttpInfo($smsPreviewRequest);
        return $response;
    }

    /**
     * Operation previewSmsMessageWithHttpInfo
     *
     * Preview SMS message
     *
     * @param  \Infobip\Model\SmsPreviewRequest $smsPreviewRequest (optional)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsPreviewResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function previewSmsMessageWithHttpInfo($smsPreviewRequest = null)
    {
        $request = $this->previewSmsMessageRequest($smsPreviewRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->previewSmsMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->previewSmsMessageApiException($e);
        }
    }

    /**
     * Operation previewSmsMessageAsync
     *
     * Preview SMS message
     *
     * @param  \Infobip\Model\SmsPreviewRequest $smsPreviewRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function previewSmsMessageAsync($smsPreviewRequest = null)
    {
        return $this->previewSmsMessageAsyncWithHttpInfo($smsPreviewRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation previewSmsMessageAsyncWithHttpInfo
     *
     * Preview SMS message
     *
     * @param  \Infobip\Model\SmsPreviewRequest $smsPreviewRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function previewSmsMessageAsyncWithHttpInfo($smsPreviewRequest = null)
    {
        $request = $this->previewSmsMessageRequest($smsPreviewRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->previewSmsMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->previewSmsMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'previewSmsMessage'
     *
     * @param  \Infobip\Model\SmsPreviewRequest $smsPreviewRequest (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function previewSmsMessageRequest($smsPreviewRequest = null)
    {
        $resourcePath = '/sms/1/preview';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            ['application/json', 'application/xml']
        );

        // for model (json/xml)
        if (isset($smsPreviewRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($smsPreviewRequest));
            } else {
                $httpBody = $smsPreviewRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'previewSmsMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|\Infobip\Model\SmsPreviewResponse|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function previewSmsMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;


        $type = '\Infobip\Model\SmsPreviewResponse';
        if ($type === '\SplFileObject') {
            $content = $responseBody; //stream goes to serializer
        } else {
            $content = (string) $responseBody;
        }
        $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'previewSmsMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function previewSmsMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode >= 400 && $statusCode <= 499) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode >= 500 && $statusCode <= 599) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }

        $data = ObjectSerializer::deserialize(
            $apiException->getResponseBody(),
            '\Infobip\Model\SmsPreviewResponse',
            $apiException->getResponseHeaders()
        );
        $apiException->setResponseObject($data);
        return $apiException;
    }

    /**
     * Operation sendBinarySmsMessage
     *
     * Send binary SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedBinaryRequest $smsAdvancedBinaryRequest smsAdvancedBinaryRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException
     */
    public function sendBinarySmsMessage($smsAdvancedBinaryRequest)
    {
        list($response) = $this->sendBinarySmsMessageWithHttpInfo($smsAdvancedBinaryRequest);
        return $response;
    }

    /**
     * Operation sendBinarySmsMessageWithHttpInfo
     *
     * Send binary SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedBinaryRequest $smsAdvancedBinaryRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendBinarySmsMessageWithHttpInfo($smsAdvancedBinaryRequest)
    {
        $request = $this->sendBinarySmsMessageRequest($smsAdvancedBinaryRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendBinarySmsMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendBinarySmsMessageApiException($e);
        }
    }

    /**
     * Operation sendBinarySmsMessageAsync
     *
     * Send binary SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedBinaryRequest $smsAdvancedBinaryRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendBinarySmsMessageAsync($smsAdvancedBinaryRequest)
    {
        return $this->sendBinarySmsMessageAsyncWithHttpInfo($smsAdvancedBinaryRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendBinarySmsMessageAsyncWithHttpInfo
     *
     * Send binary SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedBinaryRequest $smsAdvancedBinaryRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendBinarySmsMessageAsyncWithHttpInfo($smsAdvancedBinaryRequest)
    {
        $request = $this->sendBinarySmsMessageRequest($smsAdvancedBinaryRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendBinarySmsMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendBinarySmsMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendBinarySmsMessage'
     *
     * @param  \Infobip\Model\SmsAdvancedBinaryRequest $smsAdvancedBinaryRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendBinarySmsMessageRequest($smsAdvancedBinaryRequest)
    {
        // verify the required parameter 'smsAdvancedBinaryRequest' is set
        if ($smsAdvancedBinaryRequest === null || (is_array($smsAdvancedBinaryRequest) && count($smsAdvancedBinaryRequest) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $smsAdvancedBinaryRequest when calling sendBinarySmsMessage'
            );
        }

        $resourcePath = '/sms/2/binary/advanced';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            ['application/json', 'application/xml']
        );

        // for model (json/xml)
        if (isset($smsAdvancedBinaryRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($smsAdvancedBinaryRequest));
            } else {
                $httpBody = $smsAdvancedBinaryRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendBinarySmsMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendBinarySmsMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\SmsResponse';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendBinarySmsMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendBinarySmsMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 500) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Operation sendSmsMessage
     *
     * Send SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedTextualRequest $smsAdvancedTextualRequest smsAdvancedTextualRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException
     */
    public function sendSmsMessage($smsAdvancedTextualRequest)
    {
        list($response) = $this->sendSmsMessageWithHttpInfo($smsAdvancedTextualRequest);
        return $response;
    }

    /**
     * Operation sendSmsMessageWithHttpInfo
     *
     * Send SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedTextualRequest $smsAdvancedTextualRequest (required)
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException, HTTP status code, HTTP response headers (array of strings)
     */
    public function sendSmsMessageWithHttpInfo($smsAdvancedTextualRequest)
    {
        $request = $this->sendSmsMessageRequest($smsAdvancedTextualRequest);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
                return $this->sendSmsMessageResponse($response, $request->getUri());
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            }
        } catch (ApiException $e) {
            throw $this->sendSmsMessageApiException($e);
        }
    }

    /**
     * Operation sendSmsMessageAsync
     *
     * Send SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedTextualRequest $smsAdvancedTextualRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsMessageAsync($smsAdvancedTextualRequest)
    {
        return $this->sendSmsMessageAsyncWithHttpInfo($smsAdvancedTextualRequest)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation sendSmsMessageAsyncWithHttpInfo
     *
     * Send SMS message
     *
     * @param  \Infobip\Model\SmsAdvancedTextualRequest $smsAdvancedTextualRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function sendSmsMessageAsyncWithHttpInfo($smsAdvancedTextualRequest)
    {
        $request = $this->sendSmsMessageRequest($smsAdvancedTextualRequest);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($request) {
                    return $this->sendSmsMessageResponse($response, $request->getUri());
                },
                function ($exception) {
                    $statusCode = $exception->getCode();
                    $response = $exception->getResponse();
                    $e = new ApiException(
                        "[{$statusCode}] {$exception->getMessage()}",
                        $statusCode,
                        $response ? $response->getHeaders() : null,
                        $response ? (string) $response->getBody() : null
                    );
                    throw $this->sendSmsMessageApiException($e);
                }
            );
    }

    /**
     * Create request for operation 'sendSmsMessage'
     *
     * @param  \Infobip\Model\SmsAdvancedTextualRequest $smsAdvancedTextualRequest (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    protected function sendSmsMessageRequest($smsAdvancedTextualRequest)
    {
        // verify the required parameter 'smsAdvancedTextualRequest' is set
        if ($smsAdvancedTextualRequest === null || (is_array($smsAdvancedTextualRequest) && count($smsAdvancedTextualRequest) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $smsAdvancedTextualRequest when calling sendSmsMessage'
            );
        }

        $resourcePath = '/sms/2/text/advanced';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';





        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml'],
            ['application/json', 'application/xml']
        );

        // for model (json/xml)
        if (isset($smsAdvancedTextualRequest)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($smsAdvancedTextualRequest));
            } else {
                $httpBody = $smsAdvancedTextualRequest;
            }
        } elseif (count($formParams) > 0) {
            if ($headers['Content-Type'] === 'multipart/form-data') {
                $boundary = '----'.hash('sha256', uniqid('', true));
                $headers['Content-Type'] .= '; boundary=' . $boundary;
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents, $boundary);
            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\Query::build($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires HTTP basic authentication
        if (!empty($this->config->getUsername()) || !(empty($this->config->getPassword()))) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }
        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }
        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp\Psr7\Query::build($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create response for operation 'sendSmsMessage'
     *
     * @param \GuzzleHttp\Psr7\Response $response
     * @param string $requestUri
     *
     * @throws \Infobip\ApiException on non-2xx response
     * @return array of \Infobip\Model\SmsResponse|\Infobip\Model\SmsApiException|\Infobip\Model\SmsApiException|null, HTTP status code, HTTP response headers (array of strings)
     */
    protected function sendSmsMessageResponse($response, $requestUri)
    {
        $statusCode = $response->getStatusCode();
        $responseBody = $response->getBody();
        $responseHeaders = $response->getHeaders();

        if ($statusCode < 200 || $statusCode > 299) {
            throw new ApiException(
                sprintf('[%d] Error connecting to the API (%s)', $statusCode, $requestUri),
                $statusCode,
                $responseHeaders,
                $responseBody
            );
        }

        $responseObject = null;

        if ($statusCode === 200) {
            $type = '\Infobip\Model\SmsResponse';
            if ($type === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = (string) $responseBody;
            }
            $responseObject = ObjectSerializer::deserialize($content, $type, $responseHeaders);

            return [
                $responseObject,
                $statusCode,
                $responseHeaders
            ];
        }

        return [
            $responseObject,
            $statusCode,
            $responseHeaders
        ];
    }

    /**
     * Adapt given \Infobip\ApiException for operation 'sendSmsMessage'
     *
     * @param \Infobip\ApiException $apiException
     *
     * @return \Infobip\ApiException
     */
    protected function sendSmsMessageApiException($apiException)
    {
        $statusCode = $apiException->getCode();

        if ($statusCode === 400) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        if ($statusCode === 500) {
            $data = ObjectSerializer::deserialize(
                $apiException->getResponseBody(),
                '\Infobip\Model\SmsApiException',
                $apiException->getResponseHeaders()
            );
            $apiException->setResponseObject($data);
            return $apiException;
        }
        return $apiException;
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
