<!-- latest transactions -->
<section class="latest-transaction">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="header-text text-center">
                    <h5><?php echo $deposit_withdrawals_section['single']['heading']??''; ?></h5>
                    <h3><?php echo $deposit_withdrawals_section['single']['sub_heading']??''; ?></h3>
                    <p class="mx-auto"><?php echo $deposit_withdrawals_section['single']['short_text']??''; ?></p>
                </div>
                <div class="nav justify-content-center mb-5" id="nav-tab" role="tablist">
                    <button
                        class="btn-custom active"
                        id="last-deposit-tab"
                        data-bs-toggle="tab"
                        data-bs-target="#last-deposit"
                        type="button"
                        role="tab"
                        aria-controls="last-deposit"
                        aria-selected="true"
                    >
                        <?php echo app('translator')->get('Last Deposit'); ?>
                    </button>
                    <button
                        class="btn-custom"
                        id="last-withdraw-tab"
                        data-bs-toggle="tab"
                        data-bs-target="#last-withdraw"
                        type="button"
                        role="tab"
                        aria-controls="last-withdraw"
                        aria-selected="false"
                    >
                        <?php echo app('translator')->get('Last Withdrawal'); ?>
                    </button>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col">
                <div class="tab-content" id="nav-tabContent">
                    <div
                        class="tab-pane fade show active"
                        id="last-deposit"
                        role="tabpanel"
                        aria-labelledby="last-deposit-tab"
                        tabindex="0"
                    >
                        <div class="transaction-wrapper">
                            <!-- table -->
                            <div class="table-parent table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Gateway'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Date'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $deposits->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td data-label="Name">
                                        <span class="currency">
                                           <img
                                               src="<?php echo e(getFile(optional($item->user)->image_driver , optional($item->user)->image)); ?>"
                                               class="img-fluid" alt="<?php echo app('translator')->get('doposit user image'); ?>"/>
                                           <?php echo e(optional($item->user)->fullname); ?>

                                        </span>
                                            </td>
                                            <td data-label="Amount"><?php echo e(currencyPosition($item->payable_amount_in_base_currency + 0)); ?></td>
                                            <td data-label="Gateway"><?php echo e(optional($item->gateway)->name); ?></td>
                                            <td data-label="Date"><?php echo e(dateTime($item->created_at)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div
                        class="tab-pane fade"
                        id="last-withdraw"
                        role="tabpanel"
                        aria-labelledby="last-withdraw-tab"
                        tabindex="0"
                    >
                        <div class="transaction-wrapper">
                            <!-- table -->
                            <div class="table-parent table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo app('translator')->get('Name'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Gateway'); ?></th>
                                        <th scope="col"><?php echo app('translator')->get('Date'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $withdraws->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td data-label="Name">
                                        <span class="currency">
                                          <img src="<?php echo e(getFile(optional($item->user)->image_driver , optional($item->user)->image)); ?>" class="img-fluid" alt="<?php echo app('translator')->get('withdrawal user image'); ?>"/>
                                           <?php echo e(optional($item->user)->fullname); ?>

                                        </span>
                                            </td>
                                            <td data-label="Amount"><?php echo e(currencyPosition($item->amount_in_base_currency + 0)); ?></td>
                                            <td data-label="Gateway"><?php echo e(optional($item->gateway)->name); ?></td>
                                            <td data-label="Date"><?php echo e(dateTime($item->created_at)); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH D:\server\htdocs\hyip_8\demo\resources\views/themes/dodgerblue/sections/deposit_withdrawals_section.blade.php ENDPATH**/ ?>