<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class NotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $notificationTemplate =  array(
            array('id' => 1, 'language_id' => 1, 'name' => 'Profile has been updated', 'email_from' => 'support@achi.com', 'template_key' => 'PROFILE_UPDATE', 'subject' => 'Profile has been updated', 'short_keys' => '{"sender":"Sender Name","amount":"Received Amount","currency":"Transfer Currency","transaction":"Transaction Number"}', 'email' => '[[transaction]]', 'sms' => '[[transaction]]', 'in_app' => '[[transaction]]', 'push' => '[[username]] replied ticket\nTicket : [[ticket_id]]', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 1, 'lang_code' => 'en', 'created_at' => '2021-08-02 06:05:43', 'updated_at' => '2024-02-04 22:17:45'),
            array('id' => 5, 'language_id' => 1, 'name' => 'Support Ticket Create', 'email_from' => 'support@achi.com', 'template_key' => 'SUPPORT_TICKET_CREATE', 'subject' => 'New Support Ticket', 'short_keys' => '{"ticket_id":"Support Ticket ID","username":"username"}', 'email' => '[[username]] created a ticket\nTicket : [[ticket_id]]', 'sms' => '[[sender]] sent money to your account amount [[amount]] [[currency]]. Transaction: #[[transaction]]', 'in_app' => '[[username]] created a ticket\nTicket : [[ticket_id]]', 'push' => '[[username]] created a ticket\nTicket : [[ticket_id]]\n\n', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 1, 'lang_code' => 'en', 'created_at' => '2021-08-02 06:05:43', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 8, 'language_id' => 2, 'name' => 'CHEK', 'email_from' => 'support@achi.com', 'template_key' => 'PROFILE_UPDATE', 'subject' => 'aaa', 'short_keys' => '{"sender":"Sender Name","amount":"Received Amount","currency":"Transfer Currency","transaction":"Transaction Number"}', 'email' => '<p>ssd</p>', 'sms' => 'Your profile is updated', 'in_app' => '[[transaction]]', 'push' => '[[username]] replied ticket\nTicket : [[ticket_id]]', 'status' => '{"mail":"0","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-06 21:26:59', 'updated_at' => '2024-02-04 22:17:51'),
            array('id' => 10, 'language_id' => 1, 'name' => 'Add Balance', 'email_from' => 'support@achi.com', 'template_key' => 'ADD_BALANCE', 'subject' => 'Your Account has been credited', 'short_keys' => '{"transaction":"Transaction Number","amount":"Request Amount By Admin","main_balance":"Users Balance After this operation"}', 'email' => '[[amount]] credited to your account.\n\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'sms' => '[[amount]] credited to your account.\n\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'in_app' => '[[amount]] credited to your account.\n\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'push' => '[[amount]] credited to your account.\n\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 11, 'language_id' => 1, 'name' => 'KYC Approved Successfully', 'email_from' => 'support@achi.com', 'template_key' => 'KYC_APPROVED', 'subject' => 'Your KYC has been approved', 'short_keys' => '{}', 'email' => 'Your KYC has been approved', 'sms' => 'Your KYC has been approved', 'in_app' => 'Your KYC has been approved', 'push' => 'Your KYC has been approved', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 12, 'language_id' => 1, 'name' => 'KYC Rejected Successfully', 'email_from' => 'support@achi.com', 'template_key' => 'KYC_REJECTED', 'subject' => 'Your KYC has been rejected', 'short_keys' => '{}', 'email' => 'Your KYC has been rejected', 'sms' => 'Your KYC has been rejected', 'in_app' => 'Your KYC has been rejected', 'push' => 'Your KYC has been rejected', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 13, 'language_id' => 1, 'name' => 'Admin Replied Ticket', 'email_from' => 'support@achi.com', 'template_key' => 'ADMIN_REPLIED_TICKET', 'subject' => 'Admin Replied Ticket', 'short_keys' => '{"ticket_id":"Support Ticket ID"}', 'email' => 'Admin replied \r\nTicket : [[ticket_id]]', 'sms' => 'Admin replied \r\nTicket : [[ticket_id]]', 'in_app' => 'Admin replied \r\nTicket : [[ticket_id]]', 'push' => 'Admin replied \r\nTicket : [[ticket_id]]', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 14, 'language_id' => 1, 'name' => 'Balance deducted by Admin', 'email_from' => 'support@achi.com', 'template_key' => 'DEDUCTED_BALANCE', 'subject' => 'Your Account has been debited', 'short_keys' => '{"transaction":"Transaction Number","amount":"Request Amount By Admin","main_balance":"Users Balance After this operation"}', 'email' => '[[amount]] debited from your account.\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'sms' => '[[amount]] debited from your account.\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'in_app' => '[[amount]] [[currency]] debited from your account.\n\nYour Current Balance [[main_balance]][[currency]]\n\nTransaction: #[[transaction]][[amount]] debited from your account.\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'push' => '[[amount]] debited from your account.\n\nYour Current Balance [[main_balance]]\n\nTransaction: #[[transaction]]', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 15, 'language_id' => 1, 'name' => 'Payment Request', 'email_from' => 'support@achi.com', 'template_key' => 'PAYMENT_REQUEST', 'subject' => 'Payment Request', 'short_keys' => '{"gateway":"gateway","currency":"currency","username":"username"}', 'email' => '[[username]] deposit request [[amount]] via [[gateway]]\r\n', 'sms' => '[[username]] deposit request [[amount]] via [[gateway]]\r\n', 'in_app' => '[[username]] deposit request [[amount]] via [[gateway]]\r\n', 'push' => '[[username]] deposit request [[amount]] via [[gateway]]\r\n', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 16, 'language_id' => 1, 'name' => 'Withdraw Request', 'email_from' => 'support@achi.com', 'template_key' => 'WITHDRAW_REQUEST', 'subject' => 'Withdraw Request', 'short_keys' => '{"gateway":"gateway","currency":"currency","username":"username"}', 'email' => '[[username]] withdraw request [[amount]] via [[gateway]]\r\n', 'sms' => '[[username]] withdraw request [[amount]] via [[gateway]]\r\n', 'in_app' => '[[username]] withdraw request [[amount]] via [[gateway]]\r\n', 'push' => '[[username]] withdraw request [[amount]] via [[gateway]]\r\n', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 17, 'language_id' => 1, 'name' => 'Two-Factor Authentication', 'email_from' => 'support@achi.com', 'template_key' => 'TWO_FACTOR_AUTH', 'subject' => 'Two-Factor Authentication Code', 'short_keys' => '{"code":"Authentication Code"}', 'email' => 'Your authentication code is [[code]].', 'sms' => 'Your authentication code is [[code]].', 'in_app' => 'Your authentication code is [[code]].', 'push' => 'Your authentication code is [[code]].', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 18, 'language_id' => 1, 'name' => 'Password Reset', 'email_from' => 'support@achi.com', 'template_key' => 'PASSWORD_RESET', 'subject' => 'Password Reset Request', 'short_keys' => '{"reset_link":"Password Reset Link"}', 'email' => 'You requested a password reset. Click the link to reset your password: [[reset_link]].', 'sms' => 'You requested a password reset. Use this link: [[reset_link]].', 'in_app' => 'You requested a password reset. Use this link: [[reset_link]].', 'push' => 'You requested a password reset. Use this link: [[reset_link]].', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 19, 'language_id' => 1, 'name' => 'Account Verification', 'email_from' => 'support@achi.com', 'template_key' => 'ACCOUNT_VERIFICATION', 'subject' => 'Account Verification Required', 'short_keys' => '{"verification_link":"Verification Link"}', 'email' => 'Please verify your account using the following link: [[verification_link]].', 'sms' => 'Please verify your account using the following link: [[verification_link]].', 'in_app' => 'Please verify your account using the following link: [[verification_link]].', 'push' => 'Please verify your account using the following link: [[verification_link]].', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 20, 'language_id' => 1, 'name' => 'Email Verification', 'email_from' => 'support@achi.com', 'template_key' => 'EMAIL_VERIFICATION', 'subject' => 'Email Verification Required', 'short_keys' => '{"verification_link":"Verification Link"}', 'email' => 'Please verify your email using the following link: [[verification_link]].', 'sms' => 'Please verify your email using the following link: [[verification_link]].', 'in_app' => 'Please verify your email using the following link: [[verification_link]].', 'push' => 'Please verify your email using the following link: [[verification_link]].', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 21, 'language_id' => 1, 'name' => 'New User Registration', 'email_from' => 'support@achi.com', 'template_key' => 'NEW_USER_REGISTRATION', 'subject' => 'Welcome to our platform', 'short_keys' => '{"username":"New User Name"}', 'email' => 'Welcome, [[username]]! Thank you for registering.', 'sms' => 'Welcome, [[username]]! Thank you for registering.', 'in_app' => 'Welcome, [[username]]! Thank you for registering.', 'push' => 'Welcome, [[username]]! Thank you for registering.', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 22, 'language_id' => 1, 'name' => 'Account Deactivation', 'email_from' => 'support@achi.com', 'template_key' => 'ACCOUNT_DEACTIVATION', 'subject' => 'Account Deactivation Notice', 'short_keys' => '{"username":"Username"}', 'email' => 'Dear [[username]], your account has been deactivated.', 'sms' => 'Dear [[username]], your account has been deactivated.', 'in_app' => 'Dear [[username]], your account has been deactivated.', 'push' => 'Dear [[username]], your account has been deactivated.', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 23, 'language_id' => 1, 'name' => 'Email Address Updated', 'email_from' => 'support@achi.com', 'template_key' => 'EMAIL_ADDRESS_UPDATED', 'subject' => 'Your Email Address has been Updated', 'short_keys' => '{"old_email":"Old Email Address","new_email":"New Email Address"}', 'email' => 'Your email address has been updated from [[old_email]] to [[new_email]].', 'sms' => 'Your email address has been updated from [[old_email]] to [[new_email]].', 'in_app' => 'Your email address has been updated from [[old_email]] to [[new_email]].', 'push' => 'Your email address has been updated from [[old_email]] to [[new_email]].', 'status' => '{"mail":"1","sms":"1","in_app":"1","push":"1"}', 'notify_for' => 0, 'lang_code' => 'en', 'created_at' => '2023-10-07 16:18:47', 'updated_at' => '2024-02-04 22:06:47'),
            array('id' => 24, 'language_id' => 1, 'name' => 'Password Reset Notification', 'email_from' => 'talk@gmail.com', 'template_key' => 'PASSWORD_RESET_NOTIFICATION', 'subject' => 'Reset Your Password', 'short_keys' => '{"message":"message"}', 'email' => 'You are receiving this email because we received a password reset request for your account.[[message]]
                This password reset link will expire in 60 minutes.
                If you did not request a password reset, no further action is required.', 'sms' => '', 'in_app' => '', 'push' => '', 'status' => '{"mail":"1","sms":"0","in_app":"0","push":"0"}', 'notify_for' => '0', 'lang_code' => 'en', 'created_at' => '2023-10-08 04:18:47', 'updated_at' => '2024-05-04 15:21:00'),
        );

        DB::table('notification_templates')->insert($notificationTemplate);

    }
}
