
// add bg to nav
window.addEventListener("scroll", function () {
   let scrollpos = window.scrollY;
   const header = document.querySelector("nav");
   const headerHeight = header.offsetHeight;
   if (scrollpos >= headerHeight) {
      header.classList.add("active");
   } else {
      header.classList.remove("active");
   }
});



// active nav item
const navItem = document.getElementsByClassName("nav-link");
for (const element of navItem) {
   element.addEventListener("click", () => {
      for (const ele of navItem) {
         ele.classList.remove("active");
      }
      element.classList.add("active");
   });
}

// copy text
const copyText = (id) => {
   const text = document.getElementById(id);
   text.select();
   navigator.clipboard.writeText(text.value);
   document.getElementById("copyBtn").innerText = "Link copied";
   setTimeout(() => {
      document.getElementById("copyBtn").innerText = "Copy Link";
   }, 1000);
};

// input file preview
const previewImage = (id) => {
   document.getElementById(id).src = URL.createObjectURL(event.target.files[0]);
};

const toggleSideMenu = () => {
   document.getElementById("sidebar").classList.toggle("active");
   document.getElementById("content").classList.toggle("active");
};

var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
   return new bootstrap.Tooltip(tooltipTriggerEl);
});

$(document).ready(function () {
   $(".js-example-basic-single").select2();
   $(".js-example-basic-single-modal").select2({
      dropdownParent: $("#formModal"),
   });
   $(".js-example-basic-multiple-limit").select2({
      maximumSelectionLength: 5,
   });


   // AOS ANIMATION
   AOS.init();

   $(".card-boxes").owlCarousel({
      loop: true,
      margin: -25,
      rtl: false,
      nav: false,
      dots: false,
      autoplay: false,
      autoplayTimeout: 3000,
      responsive: {
         0: {
            items: 1,
         },
         576: {
            items: 2,
         },
      },
   });

   $(".testimonials").owlCarousel({
      loop: true,
      margin: 0,
      rtl: false,
      nav: true,
      dots: true,
      autoplay: true,
      autoplayTimeout: 3000,
      responsive: {
         0: {
            items: 1,
         },
         768: {
            items: 1,
         },
         992: {
            items: 1,
         },
      },
   });

   $(".investor-wrapper").owlCarousel({
      loop: true,
      margin: 25,
      rtl: false,
      nav: false,
      dots: true,
      autoplay: true,
      autoplayTimeout: 3000,
      responsive: {
         0: {
            items: 1,
         },
         768: {
            items: 2,
         },
         992: {
            items: 3,
         },
         1200: {
            items: 4,
         },
      },
   });
   $(".transaction-wrapper").owlCarousel({
      loop: true,
      margin: 25,
      rtl: false,
      nav: false,
      dots: true,
      autoplay: true,
      autoplayTimeout: 3000,
      responsive: {
         0: {
            items: 1,
         },
         768: {
            items: 2,
         },
         992: {
            items: 3,
         },
         1200: {
            items: 4,
         },
      },
   });

   $(".gateways").owlCarousel({
      loop: true,
      margin: 15,
      rtl: false,
      nav: false,
      dots: false,
      autoplay: true,
      autoplayTimeout: 5000,
      responsive: {
         0: {
            items: 2,
         },
         552: {
            items: 3,
         },
         768: {
            items: 4,
         },
         992: {
            items: 7,
         },
      },
   });

   $("#shareBlock").socialSharingPlugin({
      urlShare: window.location.href,
      description: $("meta[name=description]").attr("content"),
      title: $("title").text(),
   });
});

$(document).on('click', "#togglePassword", function (){
    const type = $('#id_password').getAttribute("type") === "password" ? "text" : "password";
    $('#id_password').setAttribute("type", type);
    $('##togglePassword').classList.toggle("active");
})


